/*
 * Decompiled with CFR 0.152.
 */
package com.proflogic.acddb2fspotdb;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ACDDB2FSpotDB {
    public static final String VERSION = "1.0 beta (2010-02-18)";
    public static final File DEFAULT_BASE_DIRECTORY = new File(System.getProperty("user.home"), "Pictures");

    public static void main(String[] args) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        int totalPhotosAdded = 0;
        int totalPhotosSkipped = 0;
        int totalTagsAdded = 0;
        int totalTagsSkipped = 0;
        int totalPhotoTagsAdded = 0;
        int totalPhotoTagsSkipped = 0;
        boolean isDebug = false;
        try {
            File baseDir;
            Options options = new Options();
            options.addOption("d", "debug", false, "enable debug output");
            options.addOption("h", "help", false, "print this help and exit");
            Option pathOption = new Option("p", "path", true, "base directory for photos, default (" + DEFAULT_BASE_DIRECTORY.getAbsolutePath() + ")");
            pathOption.setArgName("base directory");
            options.addOption(pathOption);
            options.addOption("P", "progress", false, "show progress");
            options.addOption("s", "simulate", false, "simulation only");
            options.addOption("v", "verbose", false, "verbose output");
            options.addOption("V", "version", false, "print version and exit");
            PosixParser parser = new PosixParser();
            CommandLine cmd = parser.parse(options, args);
            isDebug = cmd.hasOption("d");
            if (cmd.hasOption("V")) {
                System.out.println(VERSION);
                System.exit(0);
            }
            if (cmd.hasOption("p")) {
                baseDir = new File(cmd.getOptionValue("p"));
                if (!baseDir.isDirectory()) {
                    System.out.println("no such directory " + baseDir.getAbsolutePath());
                    System.exit(1);
                }
            } else {
                baseDir = DEFAULT_BASE_DIRECTORY;
            }
            if (cmd.hasOption("h") || cmd.getArgs().length != 2) {
                HelpFormatter formatter = new HelpFormatter();
                System.out.println(String.valueOf(ACDDB2FSpotDB.class.getSimpleName()) + " Version " + VERSION + " by Mathias Linkerhand <proflogic@proflogic.com>");
                formatter.printHelp(String.valueOf(ACDDB2FSpotDB.class.getSimpleName()) + " [OPTION]... input-file output-file", options);
                System.exit(cmd.hasOption("h") ? 0 : 1);
            }
            boolean isSimulating = cmd.hasOption("s");
            boolean isVerbose = cmd.hasOption("v");
            boolean showProgress = cmd.hasOption("P");
            File acddbFile = new File(cmd.getArgs()[0]);
            if (!acddbFile.isFile() || !acddbFile.exists()) {
                System.out.println("No such file " + acddbFile.getAbsolutePath() + ".");
                System.exit(1);
            }
            File fspotFile = new File(cmd.getArgs()[1]);
            boolean fspotFileExists = fspotFile.exists();
            Class.forName("org.sqlite.JDBC");
            String databaseUrl = "jdbc:sqlite:" + fspotFile.getAbsolutePath();
            Connection connection = DriverManager.getConnection(databaseUrl);
            if (!fspotFileExists) {
                InputStream fSpotSqlInputStream = ACDDB2FSpotDB.class.getResourceAsStream("f-spot.sql");
                String fSpotSqlFileQueries = ACDDB2FSpotDB.toString(fSpotSqlInputStream);
                Statement statement = connection.createStatement();
                String[] stringArray = fSpotSqlFileQueries.split(";");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String query = stringArray[n2];
                    if (!query.trim().equals("")) {
                        statement.addBatch(query);
                    }
                    ++n2;
                }
                statement.executeBatch();
            }
            PreparedStatement insertPhotoStatement = connection.prepareStatement("INSERT OR IGNORE INTO 'photos' ('base_uri', 'filename', 'time', 'description', 'roll_id', 'default_version_id') VALUES (?, ?, 0, '', 0, 1)");
            PreparedStatement insertTagStatement = connection.prepareStatement("INSERT OR IGNORE INTO 'tags' ('name', 'category_id', 'is_category') SELECT ?, 'tags'.'id', 1 FROM 'tags' WHERE 'tags'.'name' = ? LIMIT 1");
            PreparedStatement insertPhotoTagStatement = connection.prepareStatement("INSERT OR IGNORE INTO 'photo_tags' ('photo_id', 'tag_id') SELECT 'photos'.'id', 'tags'.'id' FROM 'photos', 'tags' WHERE 'photos'.'base_uri' = ? AND 'photos'.'filename' = ? AND 'tags'.'name' = ?");
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(acddbFile);
            HashMap<String, String> rootPath2sysPath = new HashMap<String, String>();
            NodeList rootNodes = document.getElementsByTagName("FolderRoot");
            int rootNodesIndex = 0;
            while (rootNodesIndex < rootNodes.getLength()) {
                Element rootElement = (Element)rootNodes.item(rootNodesIndex);
                Element sysPathElement = (Element)rootElement.getElementsByTagName("SysPath").item(0);
                Element dbRootPathElement = (Element)rootElement.getElementsByTagName("DBRootPath").item(0);
                String sysPathString = "<" + dbRootPathElement.getTextContent() + ">";
                rootPath2sysPath.put(sysPathString, sysPathElement.getTextContent());
                ++rootNodesIndex;
            }
            TreeMap<String, TreeSet<String>> tagNameToTagPath = new TreeMap<String, TreeSet<String>>();
            NodeList fileNodes = document.getElementsByTagName("Asset");
            int nodeIndex = 0;
            while (nodeIndex < fileNodes.getLength()) {
                Element assetElement = (Element)fileNodes.item(nodeIndex);
                Element folderElement = (Element)assetElement.getElementsByTagName("Folder").item(0);
                Element nameElement = (Element)assetElement.getElementsByTagName("Name").item(0);
                String filename = String.valueOf(folderElement.getTextContent()) + nameElement.getTextContent();
                for (Map.Entry entry : rootPath2sysPath.entrySet()) {
                    filename = filename.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
                }
                String windowsFileDelimiter = "\\";
                String linuxFileDelimiter = "/";
                filename = filename.replace("\\", "/");
                filename = filename.replaceFirst(".:", "");
                File file = new File(baseDir, filename);
                String fSpotBaseUri = new URI(null, "file://" + file.getParent() + "/", null).toASCIIString();
                String fSpotFilename = new URI(null, file.getName(), null).toASCIIString();
                if (!isSimulating) {
                    insertPhotoStatement.setString(1, fSpotBaseUri);
                    insertPhotoStatement.setString(2, fSpotFilename);
                    insertPhotoStatement.execute();
                    if (insertPhotoStatement.getUpdateCount() > 0) {
                        ++totalPhotosAdded;
                        if (isVerbose) {
                            System.out.println("new photo: " + file.getPath());
                        }
                    } else {
                        ++totalPhotosSkipped;
                    }
                }
                NodeList tagNodes = assetElement.getElementsByTagName("AssetCategory");
                int tagNodeIndex = 0;
                while (tagNodeIndex < tagNodes.getLength()) {
                    String tagPath = tagNodes.item(tagNodeIndex).getTextContent();
                    String tagName = tagPath.substring(tagPath.lastIndexOf("\\") + 1);
                    if (tagNameToTagPath.containsKey(tagName)) {
                        Set tagPathSet = (Set)tagNameToTagPath.get(tagName);
                        if (!tagPathSet.contains(tagPath)) {
                            tagPathSet.add(tagPath);
                            System.out.println("duplicate tag: " + tagName);
                            for (String path : tagPathSet) {
                                System.out.println("\t* " + path);
                            }
                        }
                    } else {
                        tagNameToTagPath.put(tagName, new TreeSet<String>(Arrays.asList(tagPath)));
                    }
                    if (!isSimulating) {
                        String lastTag = null;
                        String[] stringArray = tagPath.split("\\\\");
                        int n = stringArray.length;
                        int n3 = 0;
                        while (n3 < n) {
                            String currentTag = stringArray[n3];
                            insertTagStatement.setString(1, currentTag);
                            insertTagStatement.setString(2, lastTag);
                            insertTagStatement.execute();
                            if (insertTagStatement.getUpdateCount() > 0) {
                                ++totalTagsAdded;
                                if (isVerbose) {
                                    System.out.println("new tag: " + currentTag);
                                }
                            } else {
                                ++totalTagsSkipped;
                            }
                            lastTag = currentTag;
                            ++n3;
                        }
                        insertPhotoTagStatement.setString(1, fSpotBaseUri);
                        insertPhotoTagStatement.setString(2, fSpotFilename);
                        insertPhotoTagStatement.setString(3, lastTag);
                        insertPhotoTagStatement.execute();
                        if (insertPhotoTagStatement.getUpdateCount() > 0) {
                            ++totalPhotoTagsAdded;
                            if (isVerbose) {
                                System.out.println("new (tag, photo): (" + lastTag + ", " + file + ")");
                            }
                        } else {
                            ++totalPhotoTagsSkipped;
                        }
                    }
                    ++tagNodeIndex;
                }
                if (showProgress) {
                    System.out.print(String.valueOf(Math.round(100.0 * (double)(nodeIndex + 1) / (double)fileNodes.getLength())) + " %\r");
                }
                ++nodeIndex;
            }
            connection.close();
            System.out.println("total photos added: " + totalPhotosAdded);
            System.out.println("total photos skipped: " + totalPhotosSkipped);
            System.out.println("total tags added: " + totalTagsAdded);
            System.out.println("total tags skipped: " + totalTagsSkipped);
            System.out.println("total (tag, photo)s added: " + totalPhotoTagsAdded);
            System.out.println("total (tag, photo)s skipped: " + totalPhotoTagsSkipped);
        }
        catch (ParserConfigurationException e) {
            if (isDebug) {
                e.printStackTrace();
            } else {
                System.out.println(e.getMessage());
            }
        }
        catch (SAXException e) {
            if (isDebug) {
                e.printStackTrace();
            } else {
                System.out.println(e.getMessage());
            }
        }
        catch (IOException e) {
            if (isDebug) {
                e.printStackTrace();
            } else {
                System.out.println(e.getMessage());
            }
        }
        catch (ClassNotFoundException e) {
            if (isDebug) {
                e.printStackTrace();
            } else {
                System.out.println(e.getMessage());
            }
        }
        catch (SQLException e) {
            if (isDebug) {
                e.printStackTrace();
            } else {
                System.out.println(e.getMessage());
            }
        }
        catch (ParseException e) {
            if (isDebug) {
                e.printStackTrace();
            } else {
                System.out.println(e.getMessage());
            }
        }
        catch (URISyntaxException e) {
            if (isDebug) {
                e.printStackTrace();
            }
            System.out.println(e.getMessage());
        }
    }

    public static String toString(InputStream inputStream) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder stringBuilder = new StringBuilder();
        String line = null;
        while ((line = reader.readLine()) != null) {
            stringBuilder.append(String.valueOf(line) + "\n");
        }
        inputStream.close();
        return stringBuilder.toString();
    }
}

